<?
///////////////////////////////////////////////////////////////////////////////
/**
* Filename: Form-Error.php
* Purpose: Manage Form Error's
* Author: TRAIDNT
* Date: 02/01/2010
*/
///////////////////////////////////////////////////////////////////////////////


class Form
{
	/**
	* array content error's value
	* @private	array
	*/
   private $_values;

	/**
	* array content input's name
	* @private	array
	*/
   private $_errors;

	/**
	* content count of error's
	* @public	int
	*/
   public  $_num_errors;


	/**
	* Constructor
	*/

	public function __construct ()
	{

       $this->_values = array();
       $this->_errors = array();
       $this->_num_errors = 0;

	}


	/**
	* FormStart
	* Note : this function just start when class start
	*/


   public function FormStart()
   {

      if(isset($_SESSION['value_array']) && isset($_SESSION['error_array']))
      {
         $this->_values 		= $_SESSION['value_array'];
         $this->_errors 		= $_SESSION['error_array'];
         $this->_num_errors 	= count($this->_errors);

         unset($_SESSION['value_array']);
         unset($_SESSION['error_array']);
      }
      else
      {
         $this->_num_errors = 0;
      }
   }


	/**
	* setValue
	* @param	str		input name
	* @param	str		new error message
	*/

   public function setValue($field, $value)
   {
      $this->_values[$field] = $value;
   }


	/**
	* setError
	* @param	str		input name
	* @param	str		input error message
	*/

   public function setError($field, $errmsg)
   {

      $this->_errors[$field] = $errmsg;

      $this->_num_errors = count($this->_errors);

   }

	/**
	* Value
	* @param	str		input name
	* @return	input error message
	*/

   public function Value($field)
   {

	  if(is_array($this->_errors))
	  {

	      if(array_key_exists($field,$this->_errors))
	      {
	         return htmlspecialchars(stripslashes($this->_errors[$field]));
	      }
	      else
	      {
	         return FALSE;
	      }

      }
      else
      {
      		return(FALSE);
      }

   }


	/**
	* getErrorArray
	* @return	error's array
	*/
   public function getErrorArray()
   {
      return $this->_errors;
   }


	public function __destruct (){
       $this->_values = NULL;
       $this->_errors = NULL;
       $this->_num_errors = 0;
 	}


};




?>
